
## MoCo: Transferring to Detection

The `train_net.py` script reproduces the object detection experiments on Pascal VOC and COCO.

### Instruction

1. Install [detectron2](https://github.com/facebookresearch/detectron2/blob/master/INSTALL.md).

1. Convert a pre-trained MoCo model to detectron2's format:
   ```
   python3 convert-pretrain-to-detectron2.py input.pth.tar output.pkl
   ```

1. Put dataset under "./datasets" directory,
   following the [directory structure](https://github.com/facebookresearch/detectron2/tree/master/datasets)
	 requried by detectron2.
	 
ie 
```
mkdir -p detection/datasets

ln -s /scratch/shared/beegfs/yuki/data/COCO2017/  detection/datasets/coco
ln -s /datasets/pascal/VOCdevkit_2007/VOC2007  detection/datasets/VOC2007
ln -s /datasets/pascal/VOCdevkit_2012/VOC2012  detection/datasets/VOC2012
```

--------------------
In addition to this, the authors of PASS have provided additional yaml files in the `config` folder to run keypoint detection, dense pose and LVIS experiments.

* DensePose can be found under detectron2/projects/DensePose